/*! \file tlk_odrm_def.h
**********************************************************************************
*Title:                        Discretix OMA DRM v2 Toolkit header file
*
* Filename:                     tlk_odrm_def.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      26.11.2007
*
* Modified:                     26.11.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_GENERAL_DEF_H_
#define _TLK_ODRM_GENERAL_DEF_H_


#ifdef __cplusplus
extern "C" {
#endif
#include "KMNG_Defs.h"

#define TLK_ODRM_SIZE_IN_BYTES_ALIGN(arg)	(((DxUint32_t)(arg))&0x3)
#define TLK_ODRM_IS_BUFFER_WORD_ALIGN(arg)	(TLK_ODRM_SIZE_IN_BYTES_ALIGN(arg) == 0)

    /* NULL validation macros*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_ODRM_IS_NULL_PARAM(param1)  /*lint -save -e506 -e774*/           \
            TLK_ODRM_IS_NULL_4PARAMS((param1),(!DX_NULL),(!DX_NULL),(!DX_NULL))  \
            /*lint -restore */

    /* Takes 2 parameters and returns an ERROR if it is null.*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_ODRM_IS_NULL_2PARAMS(param1,param2) /*lint -save -e506 -e774*/   \
            TLK_ODRM_IS_NULL_4PARAMS((param1),(param2),(!DX_NULL),(!DX_NULL))    \
            /*lint -restore */

    /* Takes 3 parameters and returns an ERROR if it is null.*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_ODRM_IS_NULL_3PARAMS(param1,param2,param3) /*lint -save -e506 -e774*/  \
            TLK_ODRM_IS_NULL_4PARAMS((param1),(param2),(param3),(!DX_NULL))            \
            /*lint -restore */

    /* Takes 4 parameters and returns an ERROR if it is null.*/
    #define TLK_ODRM_IS_NULL_4PARAMS(param1,param2,param3,param4)      \
           ((DX_NULL == ((void*)(param1)))||                           \
            (DX_NULL == ((void*)(param2)))||                           \
            (DX_NULL == ((void*)(param3)))||                           \
            (DX_NULL == ((void*)(param4))))

	/* new parameter check macros*/
	/* verifies a given TLK_ODRM_Buffer_t* mandatory parameter is valid*/
	#define TLK_ODRM_CHECK_BUFFER_PTR_VALIDITY(buffer_ptr)	\
		if ((DX_NULL == buffer_ptr) || (DX_NULL == buffer_ptr->buff_ptr)) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_NULL_POINTER);				\
		if (0 == buffer_ptr->buffSizeInBytes) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_INVALID_BUFFER_SIZE)

	/* verifies a given TLK_ODRM_KMNGKey_t* mandatory parameter is valid*/
	#define TLK_ODRM_CHECK_KEY_PTR_VALIDITY(key_ptr)	\
		if ((DX_NULL == key_ptr) || (DX_NULL == key_ptr->keyPassword_ptr) ) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_NULL_POINTER); \
		if (0 == key_ptr->keyPasswordLenInBytes) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_INVALID_BUFFER_SIZE)

	/* verifies a given TLK_ODRM_KMNGKeyRing_t* mandatory parameter is valid*/
	#define TLK_ODRM_CHECK_KEY_RING_PTR_VALIDITY(keyRing_ptr)	\
		if ((DX_NULL == keyRing_ptr) || (DX_NULL == keyRing_ptr->keyKmngRing_ptr) ||(DX_NULL == keyRing_ptr->keyKmngRingPassword_ptr)) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_NULL_POINTER); \
		if (0 == keyRing_ptr->keyKmngRingPasswordLenInBytes) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_INVALID_BUFFER_SIZE)

	/*verify a given TLK_ODRM_Buffer_t* optional parameter is valid*/
	#define TLK_ODRM_CHECK_OPTIONAL_BUFFER_PTR_VALIDITY(buffer_ptr)													\
	if (buffer_ptr != DX_NULL)																				\
	{																										\
		if (DX_NULL == buffer_ptr->buff_ptr) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_NULL_POINTER);				\
		if (0 == buffer_ptr->buffSizeInBytes) RETURN_NEW_ERROR(TLK_ODRM_RC_ERROR_INVALID_BUFFER_SIZE);		\
	}																										\


#define TLK_ODRM_AES_KEY_LENGTH_IN_BYTES                (16)

#define TLK_ODRM_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES        (140)

#define TLK_ODRM_SET_BIT_0                              (0x00000001)
#define TLK_ODRM_SET_BIT_1                              (0x00000002)
#define TLK_ODRM_SET_BIT_2                              (0x00000004)

#define TLK_ODRM_IS_CMLA_DECRYPT(param)                 ((param)&TLK_ODRM_SET_BIT_2)
#define TLK_ODRM_IS_CMLA_KDF(param)                     ((param)&TLK_ODRM_SET_BIT_1)
#define TLK_ODRM_IS_CMLA_UNWRAP(param)                  ((param)&TLK_ODRM_SET_BIT_0)

#define TLK_ODRM_KEK_SIZE_IN_BYTES                      (16)

#define TLK_ODRM_Z_LENGTH_IN_BYTES                      (128)

#define TLK_ODRM_C1_LENGTH_IN_BYTES                     (128)
#define TLK_ODRM_C2_LENGTH_IN_BYTES                     (40)
#define TLK_ODRM_C_LENGTH_IN_BYTES                      ((TLK_ODRM_C1_LENGTH_IN_BYTES) + (TLK_ODRM_C2_LENGTH_IN_BYTES))
#define TLK_ODRM_DELTA_OF_C1_Z_IN_BYTES                 ((TLK_ODRM_C1_LENGTH_IN_BYTES) - (TLK_ODRM_Z_LENGTH_IN_BYTES))

#define TLK_ODRM_Z_LENGTH_IN_WORDS                       ((TLK_ODRM_Z_LENGTH_IN_BYTES)/(4))

#define TLK_ODRM_AES_WRAPPED_KEY_SIZE_IN_BYTES           (24)
#define TLK_ODRM_AES_CONCAT_KEYS_POOL_SIZE_IN_BYTES      (32UL)
#define TLK_ODRM_AES_KEY_POOL_SIZE_IN_BYTES              (16UL)
#define TLK_ODRM_ENCR_KEY_BUFF_SIZE_ALIGN_IN_BYTES       KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES



#define TLK_ODRM_8TH_BIT_OFF                            (0x7F)
#define TLK_ODRM_LLF_CONVERT_IN_WORDS(someValue)        DX_DIVIDE_ROUND_UP((someValue),(4))


#define TLK_ODRM_LLF_WORD_ALLIGN(arg)                                                           \
                                 /*lint -save -e778*/                                           \
                                ((((DxUint32_t)(arg)) & (0x3)) ?                                \
                                (((((DxUint32_t)(arg))>>(2))+1)<<(2)) : ((DxUint32_t)(arg)))    \
                                /*lint -restore */

#define  ODRMTLK_TST_WORKSPACE_SIZE  KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES +  KMNG_SYM_ENCR_KEY_BUFF_SIZE_IN_BYTES +  sizeof(CRYS_RSAPrimeData_t)*2 + TLK_ODRM_RSA_WRAPPED_KEY_SIZE_IN_BYTES

#define DX_1_WORD_PARAMS        (1)
#define DX_2_WORDS_PARAMS       (2)
#define DX_3_WORDS_PARAMS       (3)
#define DX_4_WORDS_PARAMS       (4)
#define DX_5_WORDS_PARAMS       (5)
#define DX_6_WORDS_PARAMS       (6)
#define DX_7_WORDS_PARAMS       (7)
#define DX_8_WORDS_PARAMS       (8)
#define DX_9_WORDS_PARAMS       (9)
#define DX_10_WORDS_PARAMS      (10)
#define DX_11_WORDS_PARAMS      (11)
#define DX_12_WORDS_PARAMS      (12)
#define DX_13_WORDS_PARAMS      (13)
#define DX_14_WORDS_PARAMS      (14)

#ifdef __cplusplus
}
#endif

#endif /*_TLK_ODRM_GENERAL_DEF_H_*/
